﻿$(document).ready(function () {
    var actionName = $("#hidActionName").val();
    var div;
    switch (actionName) {
        case ("VACATIONINFO"):
        case ("FLIGHTDETAIL"):
        case ("FLIGHTREVIEW"):
        case ("EXTENSION"):
            div = $("div.booking-progress__label:contains('FLIGHTS, ROOMS + EXTENSIONS')").parent();
            break;
        case ("OPTIONALTOURS"):
        case ("EXTRASERVICE"):
            div = $("div.booking-progress__label:contains('OPTIONAL TOURS + EXTRAS')").parent();
            break;
        case ("ACCOUNT"):
        case ("ACCOUNTCONFIRM"):
        case ("CHANGEPASSWORD"):
            div = $("div.booking-progress__label:contains('SIGN IN OR CREATE ACCOUNT')").parent();
            break;
        case ("PASSENGERDETAIL"):
        case ("PASSENGERDETAILVIEW"):
            div = $("div.booking-progress__label:contains('PASSENGER DETAILS')").parent();
            break;
        case ("SEATMAP"):
        case ("INSURANCE"):
            div = $("div.booking-progress__label:contains('SEATS + INSURANCE')").parent();
            break;
        case ("REVIEW"):
            div = $("div.booking-progress__label:contains('REVIEW')").parent();
            break;
        case ("PAYMENT"):
            div = $("div.booking-progress__label:contains('PAYMENT')").parent();
            break;
        case ("FINALCONFIRMATION"):
            div = $("div.booking-progress__label:contains('CONFIRMATION')").parent();
            break;
        default: break;
    }
    if ($(div) != undefined) {
        $(div).removeClass().addClass("booking-progress__item booking-progress__item--active");
        $(div).prevAll().removeClass().addClass("booking-progress__item booking-progress__item--completed");
        $(div).nextAll().removeClass().addClass("booking-progress__item");
    }
    if (actionName == "FINALCONFIRMATION") {
        $(div).removeClass().addClass("booking-progress__item booking-progress__item--completed");
    }
});

var UniqueKey;

function getQueryString(name) {
    var reg = new RegExp("(^|&)" + name + "=([^&]*)(&|$)", "i");
    var r = window.location.search.substr(1).match(reg);
    if (r != null) return unescape(r[2]);
    return null;
}

var InitRightSummary = function (data) {
    if (typeof(data) === 'object') {
        var html = template('summary', data);
        document.getElementById('contentDiv').innerHTML = html;
    }    
};

function InitRight(data) {
    if (typeof (data) === 'object') {
        var html = template('breakDownInfo', data);
        document.getElementById('rightDiv').innerHTML = html;
    }    
}


function CreateTourOrder(costId, airline,packageGroup) {
    $.ajax({
        type: 'POST',
        url: "/BookingAjax/CreateTourOrderMod",
        traditional: false,
        data: { "CostId": costId, "Airline": airline,"PackageGroup":packageGroup },
        success: function(result) {
            if (result != "") {
                location.href = "/ObsoleteBooking/ChangeDatePage?uniqueKey=" + result;
            } else
                CreateTourOrder(costId, airline);
        }
    })
}
function CreatePassport(TourOrderId) {
    $.ajax({
        type: 'POST',
        url: "/AccountAjax/CreatePassportMod",
        traditional: false,
        data: { "TourOrderId": TourOrderId },
        beforeSend: function () {
            $("#divcover").show();
        },
        complete: function () {
            $("#divcover").hide();
        },
        success: function (result) {
            if (result != "") {
                location.href = "/Account/PassportDetail?key=" + result;
            }
        }
    });
}
function CloseTitleDiv() {
    $("#divTitle").hide();
}

function OpenTitleDiv() {
    $("#divTitle").show();
}

//function ChangeDate(e){
//    var costId = $(e).attr("costid");
//    var airline = $(e).attr("airline");
//    var key = $("#hidKey").val();
//    $.ajax({
//        type: 'POST',
//        url: "/BookingAjax/ChangeDate",
//        traditional: false,
//        data: { "costId":costId,"airline":airline,"key":key  },
//        success: function (result) {
//            location.href = "/Booking/DepartureAirport?UniqueKey=" + key;
//        }
//    });
//}

function OpenChangeDateDiv(){
    $("#divCostList").show();
}

function CloseChangeDateDiv(){
    $("#divCostList").hide();
}

function ChooseDate(e){
    $(".changeDateChoose").removeClass("selected");
    e.addClass("selected");
}

function ChangeDateToDeparture(){
    var costid=$(".selected").attr("costid");
    var airline=$(".selected").attr("airline");
    //var group=$(".selected").attr("hotelgroup");
    var hgroup=null;
    var hcount = $("#hidcount").val();
    for(var i=1;i<=hcount;i++)
    {
        if($('.room-'+i).prop('checked')==true)
        {
            hgroup= $('.room-'+i).val();
        }    
    }
    
    var key=$("#hidKey").val();
    $.ajax({
        type: 'POST',
        url: "/BookingAjax/ChangeDate",
        traditional: false,
        data: { "costId":costid,"airline":airline,"key":key,"group":hgroup  },
        success: function (result) {
            location.href = "/ObsoleteBooking/DepartureAirport?UniqueKey=" + key;
        }
    });
}

function ChangeDateToDeparture2(){
    var costid=$(".selected").attr("costid");
    var airline=$(".selected").attr("airline");
    //var group=$(".selected").attr("hotelgroup");
    var hgroup=$("#hidHoelGroup").val();
    
    
    var key=$("#hidKey").val();
    $.ajax({
        type: 'POST',
        url: "/BookingAjax/ChangeDate",
        traditional: false,
        data: { "costId":costid,"airline":airline,"key":key,"group":hgroup  },
        success: function (result) {
            location.href = "/ObsoleteBooking/DepartureAirport?UniqueKey=" + key;
        }
    });
}


function hotelgroup(i)
{
    var key = $("#hidKey").val();
    var hcount = $("#hidcount").val();
    var hgroup = $('.room-'+i).val();
    location.href = "/ObsoleteBooking/ChangeDatePage?UniqueKey=" + key + "&Group=" + hgroup;

}

function ChangeDateBack(){
    window.history.go(-1);
}

function ChangeYearHotelGroup(){

}

function CreateSecondOrder(TourOrderId, e, old, hideService) {
    var linkValue = $(e).attr("paytype");
    //var language = 'zh';
    //if (window.location.href.indexOf("/en/") >= 0) {
    //    language = 'en';
    //}
    var isfreesell = $(e).data("isfree");
    $.ajax({
        type: 'POST',
        url: "/AccountAjax/CreateSecondMod",
        traditional: false,
        data: { "TourOrderId": TourOrderId, "linkValue": linkValue },
        beforeSend: function () {
            $("#divcover").show();
        },
        complete: function () {
            $("#divcover").hide();
        },
        success: function (result) {
            if (result == "Failed") {
                window.location.href = "/Account/SignIn";
            }
            else if (result != "") {
                if (hideService == 'True') {
                    location.href = "/Account/EditPriceBreakdown?uniqueKey=" + result;
                } else {
                    if (isfreesell == "True") {
                        location.href = "/Account/FreesellPayment?uniqueKey=" + result;
                    } else {
                        if (old == 1)
                            location.href = "/Account/EditOldTours?uniqueKey=" + result;
                        else
                            location.href = "/Account/EditTours?uniqueKey=" + result;
                    }
                }
            }
        }
    });
}


$(function () {
    var key = getQueryString("UniqueKey");
    if (key !== null) {
        $.ajax({
            url: '/BookingAjax/RenderRight',
            type: 'GET',
            cache: false,
            data: {
                key: getQueryString("UniqueKey")
            },
            success: function (data) {
                InitRightSummary(data.Data);
                InitRight(data.Data);
            }
        });
    }
    
});
//
$('#date-price-toggle').on('click', function (e) {
	var el = e.currentTarget;
	$html.toggleClass('show-date-price');
	datePriceFlickity();
	e.preventDefault();
});
//
 $('#close-dates-prices').on('click', function(e) {
	var el = e.currentTarget;
	$html.removeClass('show-date-price');
	e.preventDefault();
});

// close filter drop down if click anywhere else
 $(document).on('click', '*:not(#date-price-toggle,.change, .dates-prices-overlay *)', function () {
	if ( $html.hasClass('show-date-price') ) {
		$html.removeClass('show-date-price');
	}
});

// stop any click within bubbling up and closing via the above
 $(document).on('click', '.dates-prices-overlay *, #date-price-toggle,.change', function (e) {
	e.stopPropagation();
});
var changeAirlineSelector = function () {
    var $currentGateway = $('select[name="selectGateway"] option:selected');
    var airlineCodes = $currentGateway.data('airlinecodes').split(',');
    var airlineNames = $currentGateway.data('airlinenames').split(',');

    var html = $currentGateway.val() !== 'Land Only' ? '<option value="*" selected>Cheapest airline</option>' : '';
    if (airlineCodes.length === airlineNames.length && airlineCodes.length > 0 && airlineNames.length > 0) {
        $.each(airlineCodes, function (i) {
            html += '<option value="' + airlineCodes[i] + '">' + airlineNames[i] + '</option>';
        });
    }
    $('select[name="selectAirline"]').html(html);
};

$('select[name="selectGateway"]').on('change', function () {
    changeAirlineSelector();
    displayDate();
});

$('select[name="selectAirline"]').on('change', function () {
    displayDate();
});

var currentRequest = null;
var displayDate = function () {
    var gateway = $('select[name="selectGateway"] option:selected').val();
    var airline = $('select[name="selectAirline"] option:selected').val();
    if (airline === '*') {
        airline += '/';
        var $airline = $('select[name="selectAirline"] :not(option:selected)');
        $.each($airline, function (i) {
            airline += ($airline[i].value + ',');
        });
        airline = airline.slice(0, -1);
    }
    var id = $('input[name="packageId"]').val();
    var month = $('a.date-price.is-active').eq(0).data('monthid');
    
    currentRequest = $.ajax({
        url: '/Home/GetAvailableDatePrice',
        type: 'GET',
        data: {
            gateway: gateway,
            airline: airline,
            packageId: id,
            lastSelectedMonth: month
        },
        success: function (result) {
            $('#loading').hide();
            $('section[name="price"]').html(result);
            datePriceFlickity();
            lockPriceTable();
        },
        beforeSend: function () {
            if (currentRequest != null) {
                currentRequest.abort();
            }
            $('#loading').show();
            $('section[name="price"]').html('');
        }
    });
};

//移动端 Booking Summary锁定位置。
var lockBookingSummary = function() {
    if( navigator.userAgent.match(/Android/i)
        || navigator.userAgent.match(/webOS/i)
        || navigator.userAgent.match(/iPhone/i)
        || navigator.userAgent.match(/iPad/i)
        || navigator.userAgent.match(/iPod/i)
        || navigator.userAgent.match(/BlackBerry/i)
        || navigator.userAgent.match(/Windows Phone/i)) {
        var $bookingHeader = $('header.booking-header');
        var $bookingSummaryTab = $('.booking-summary-tab');
        var visibleSummaryTabHeight = $bookingHeader[0].getBoundingClientRect().bottom;
        var realSummaryTabHeight = $bookingHeader.outerHeight();
        //if (parseInt(visibleSummaryTabHeight) < parseInt(realSummaryTabHeight)) {
        //    $bookingSummaryTab.css({
        //        top: 0 + 'px'
        //    });
        //} else {
        //    $bookingSummaryTab.css({
        //        top: $bookingHeader.outerHeight() + 'px'
        //    });
        //}
    }
};
lockBookingSummary();

$(window).on('scroll resize', function () {
    lockBookingSummary();
});

function printView() {
    bdhtml = window.document.body.innerHTML;//获取当前页的html代码
    window.document.body.innerHTML = bdhtml;
    sprnstr = "<!--startprint-->";//设置打印开始区域
    eprnstr = "<!--endprint-->";//设置打印结束区域
    prnhtml = bdhtml.substring(bdhtml.indexOf(sprnstr) + 17); //从开始代码向后取html
    prnhtml = prnhtml.substring(0, prnhtml.indexOf(eprnstr));//从结束代码向前取html
    window.document.body.innerHTML = "<body>"+prnhtml+"</body>";
    window.print();
    window.document.body.innerHTML = bdhtml;
}

function sendEmail(id) {
    $("#invoice").attr("disabled", "true")
    $.ajax({
        type: 'POST',
        url: "/AccountAjax/SendTripDetailEmail",
        data: { 'tourOrderId': id },
        success: function (result) {
            $("#invoice").removeAttr('disabled');
            $(".modal-close")[0].click();
            $("#sendEmailMessage").show();
            setTimeout(window.location.reload(),3000);
            //setTimeout(function () { $("#sendEmailMessage").hide(500); }, 2000);
        }
    })
}
function saveEmail(id) {
    $("#send").attr("disabled", "true")
    var email = $("#useremail").val();
    var reg = new RegExp("^[a-z0-9A-Z]+[- | a-z0-9A-Z . _]+@([a-z0-9A-Z]+(-[a-z0-9A-Z]+)?\\.)+[a-z]{2,}$");
    if (reg.test(email)) {
        $.ajax({
            type: 'POST',
            url: "/AccountAjax/UpdateClientEmail",
            data: { 'tourOrderId': id, 'email': $("#useremail").val() },
            success: function (result) {
                if (result) {
                    sendEmail(id);
                    
                }
            }
        })
    }
    else {
        //alert("E-mail format is not correct!");
        $(".emailError").show();
        $("#send").removeAttr('disabled');
    }
}
function clientEmailTransferUserEmail(id) {
    $.ajax({
        type: 'POST',
        url: "/AccountAjax/ClientEmailTransferUserEmail",
        data: { 'tourOrderId': id},
        success: function (result) {
            if (result) {
                $("#prompt").hide();
                $("#emailMessage").show();
                setTimeout(function () { $("#emailMessage").hide(500);},2000);
            }
        }
    })
}

function shareEmail(id, type) {
    $("#shareEmail").attr("disabled", "true")
    $("#shareName").attr("disabled", "true")
    $("#share").attr("disabled", "true")
    var email = $("#shareEmail").val().trim();
    var name = $("#shareName").val().trim();
    var chk_value = [];
    $('input[name="shareEmailAddress"]:checked').each(function () {
        chk_value.push($(this).val());
    });
    var reg = new RegExp(/^\w+([-+.']\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*$/);
    if (type == "Group") {

        if (chk_value.length > 0) {
            if (email != "" && !reg.test(email) || (name != "" && email == "")) {
                $(".shareEmailError").show();
                $("#shareEmail").removeAttr('disabled');
                $("#shareName").removeAttr('disabled');
                $("#share").removeAttr('disabled');
                return;
            }
            else if (email != "" && name == "") {
                $(".shareEmailNameError").show();
                $("#shareEmail").removeAttr('disabled');
                $("#shareName").removeAttr('disabled');
                $("#share").removeAttr('disabled');
                return;
            }
        } else {
            if (!reg.test(email)) {
                $(".shareEmailError").show();
                $("#shareEmail").removeAttr('disabled');
                $("#share").removeAttr('disabled');
                $("#shareName").removeAttr('disabled');
                return;
            }
            else if (name == "") {
                $(".shareEmailNameError").show();
                $("#shareEmail").removeAttr('disabled');
                $("#shareName").removeAttr('disabled');
                $("#share").removeAttr('disabled');
                return;
            }
        }

        $.ajax({
            type: 'POST',
            url: "/AccountAjax/ShareTripDetailEmail",
            data: { 'tourOrderId': id, 'email': email, 'name': name, 'opemail': $("#hidOpEmail").val(), 'IsAgent': $("#hidAgent").val(), 'IsBind': $("#hidBind").val(), 'emailList': chk_value },
            success: function (result) {
                $("#shareEmail").removeAttr('disabled');
                $("#shareEmail").val("");
                $("#shareName").removeAttr('disabled');
                $("#shareName").val("");
                $("#share").removeAttr('disabled');
                $(".modal-close")[0].click();
                $("#shareEmailMessage").show();
                setTimeout(function () { $("#shareEmailMessage").hide(500); }, 2000);
                setTimeout(function () { window.location.reload(true); }, 300);
            }
        })
    } else if (type == "Freesell") {

        if (!reg.test(email)) {
            $(".shareEmailError").show();
            $("#shareEmail").removeAttr('disabled');
            $("#shareName").removeAttr('disabled');
            $("#share").removeAttr('disabled');
            return;
        }

        $.ajax({
            type: "POST",
            url: "/FreeSellAjax/ShareFreeSellTripDetailEmail",
            data: { 'tourOrderId': id, 'email': email, 'IsAgent': $("#hidAgent").val(), 'name': name, 'opemail': $("#hidOpEmail").val() },
            success: function (result) {
                $("#shareEmail").removeAttr('disabled');
                $("#shareEmail").val("");
                $("#shareName").removeAttr('disabled');
                $("#shareName").val("");
                $("#share").removeAttr('disabled');
                $(".modal-close")[0].click();
                $("#shareEmailMessage").show();
                setTimeout(function () { $("#shareEmailMessage").hide(500); }, 2000);
            }
        });
    }

}


function AddEmail(id) {
    $("#addEmail").attr("disabled", "true")
    $("#addEmailsave").attr("disabled", "true")
    var email = $("#addEmail").val();
    var reg = new RegExp(/^\w+([-+.']\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*$/);
    if (reg.test(email)) {
        $.ajax({
            type: 'POST',
            url: "/AccountAjax/AddTripDetailEmail",
            data: { 'tourOrderId': id, 'email': email, 'opemail': $("#hidOpEmail").val() },
            success: function (result) {
                $("#addEmail").val("");
                $("#addEmailMessage").show();
                setTimeout(function () {
                    $("#addEmailMessage").hide(500);
                    $("#addEmail").removeAttr('disabled');
                    $("#addEmailsave").removeAttr('disabled');
                    location.reload();
                }, 2000);
            }
        })
    }
    else {
        $(".addEmailError").show();
        $("#addEmail").removeAttr('disabled');
        $("#addEmailsave").removeAttr('disabled');
    }

}


function GoToPartialPayment(id, type) {
    if (id == "" || parseInt(id) <= 0)
        return;
    
    var payValue = 0;
    if (type == "deposit") {
        payValue = $("[name='txtDepositPayment'][data-tourorderid='" + id + "']").val();
    }
    else if (type == "partial") {
        payValue = $("[name='txtPartialPayment'][data-tourorderid='" + id + "']").val();
    }
    if (payValue == undefined || payValue == "" || parseFloat(payValue) <= 0) {
        return;
    }

    if (type == "partial") {
        var payValueFloat = parseFloat(payValue);
        var max = parseFloat($("[name='maxPartialValue'][data-tourorderid='" + id + "']").val());
        if (max < payValueFloat) {
            return;
        }
    }
    if (type == "deposit") {
        var payValueFloat = parseFloat(payValue);
        var deposit = parseFloat($("[name='pendingDeposit'][data-tourorderid='" + id + "']").val());
        if (payValueFloat != deposit)
            return;
    }
    var language = 'zh';
    if (window.location.href.indexOf("/en/") >= 0) {
        language = 'en';
    }
    $.ajax({
        type: 'POST',
        url: "/AccountAjax/GotoPartialPayment",
        data: { 'tourOrderId': id, 'payValue': payValueFloat },
        beforeSend: function () {
            $("#divcover").show();
        },
        complete: function () {
            $("#divcover").hide();
        },
        success: function (data) {
            if (data.result) {
                location.href = "/Account/PartialPayment?uniqueKey=" + data.uniqueKey;
            } else {
                //alert(data.message);
                if (data.redirect) {
                    window.location.href = data.redirect;
                }
            }
        }
    });

}


//验证float
function Validate_Numbers(e) {
    $(e).val($(e).val().replace(/[^0-9]/g, ''));
}